/***************************************************************************
 *
 * Copyright 2010,2011 BMW Car IT GmbH
 *
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ****************************************************************************/

#include "PluginBase.h"
#include "ICommandExecutor.h"
#include "Scene.h"
#include "Log.h"

PluginBase::PluginBase(ICommandExecutor& executor, Configuration& config, ilmPluginApi api)
: mExecutor(executor)
, mConfiguration(config)
, mApi(api)
, m_previousIterationCounter(0)
{
}

PluginBase::~PluginBase()
{
}

PluginApi PluginBase::pluginGetApi() const
{
    return mApi;
}

t_ilm_const_string PluginBase::pluginGetName() const
{
    return "NoName";
}

HealthCondition PluginBase::pluginGetHealth()
{
    HealthCondition health = HealthDead;

    int currentIterationCounter = getIterationCounter();
    
    if (0 == currentIterationCounter)
    {
        // plugin has 0 iterations, so it is not running yet.
        return HealthRunning;
    }

    if (m_previousIterationCounter != currentIterationCounter)
    {
        health = HealthRunning;
        m_previousIterationCounter = currentIterationCounter;
    }
    else
    {
        LOG_WARNING(pluginGetName(),
                    "Internal loop counter did not increase. "
                    "Possible dead-lock detected.");
    }
    return health;
}
